<!DOCTYPE html>
<html class="no-js" lang="en">
  <head>
    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Meta Tags for Elite Wave Equities -->
	<title>Elite Wave Equities | Innovative Trading & Investment Solutions</title>
	<meta name="description" content="Explore Elite Wave Equities' dynamic multi-asset trading, tailored portfolio management, and data-driven investment strategies. Empower your financial growth with our expert insights and market-leading services.">
	<meta name="keywords" content="Elite Wave Equities, multi-asset trading, portfolio management, investment advisory, market analysis, financial growth, trading strategies, stock trading, commodities, indices, investment solutions">
	<meta name="author" content="Elite Wave Equities">
	<meta name="robots" content="index, follow">
	<meta property="og:title" content="Elite Wave Equities | Innovative Trading & Investment Solutions">
	<meta property="og:description" content="Unlock market opportunities with Elite Wave Equities' advanced trading services and personalized investment strategies for exceptional financial growth.">
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://www.elitewaveequities.com">
	<meta property="og:image" content="/assets/img/socials.jpg">
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:title" content="Elite Wave Equities | Innovative Trading & Investment Solutions">
	<meta property="twitter:description" content="Join Elite Wave Equities to navigate financial markets with tailored strategies, cutting-edge technology, and expert guidance for maximizing your investment returns.">
	<meta property="twitter:image" content="/assets/img/socials.jpg">

    <!-- Favicon Icon -->
    <link rel="icon" href="/assets/img/favicon.svg">
    <!-- Site Title -->
    <link rel="stylesheet" href="/assets/css/plugins/swiper.min.css">
    <link rel="stylesheet" href="/assets/css/plugins/bootstrap.min.css">
    <link rel="stylesheet" href="/assets/css/style.css">
    <style>
    #google_translate_element {
        margin: 10px 0;
        text-align: right; /* Adjust as per your page layout */
    }
    .goog-te-banner-frame.skiptranslate {
        display: none !important;
    }
    body {
        top: 0 !important;
    }
        /* Widget Container */
        .widget-container {
            position: fixed;
            bottom: 100px;
            right: 30px;
            z-index: 9999;
        }

        /* Widget Buttons */
        .widget-btn {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 60px;
            height: 60px;
            margin-top: 10px;
            border-radius: 50%;
            background-color: #25D366; /* WhatsApp green */
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            cursor: pointer;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .widget-btn:hover {
            transform: scale(1.1);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
        }

        .widget-btn img {
            width: 30px;
            height: 30px;
        }

        .widget-btn.support {
            background-color: #007BFF; /* Blue for live chat */
        }

        /* Tooltip */
        .tooltip {
            position: absolute;
            right: 70px;
            bottom: 20px;
            padding: 8px 12px;
            background: rgba(0, 0, 0, 0.8);
            color: #fff;
            border-radius: 5px;
            font-size: 14px;
            visibility: hidden;
            opacity: 0;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }

        .widget-btn:hover + .tooltip {
            visibility: visible;
            opacity: 1;
        }

        /* Floating Animation */
        @keyframes float {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-5px);
            }
        }

        .widget-btn {
            animation: float 2s infinite;
        }
</style>

  </head>

  <body>
      <div class="widget-container">
        <!-- WhatsApp Widget -->
        <div class="widget-btn" onclick="openWhatsApp()">
            <img src="https://img.icons8.com/ios-filled/50/ffffff/whatsapp.png" alt="WhatsApp Icon">
        </div>
        <div class="tooltip">WhatsApp Support</div>
    </div>

    <!-- JavaScript -->
    <script>
        // Open WhatsApp Function
        function openWhatsApp() {
            const phoneNumber = "+15024319112"; // Replace with your WhatsApp number
            const message = "Hello! I need support.";
            const url = `https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`;
            window.open(url, "_blank");
        }
    </script>
    <!-- Preloader -->
    <!-- <div id="preloader" class="preloader">
      <div class="txt-loading">
        <div class="preloader-text">
          <img class="logo-icon" src="/assets/img/logo-icon.svg" alt="logo">
        </div>
        <div class="loading-border-content">
          <div class="loading-percent">0%</div>
          <div class="loading-border-show">
            <div class="loading-border"></div>
          </div>
        </div>
      </div>
    </div> -->
    <!-- Preloader -->

    <!-- Start Header Section -->
    <header class="ak-site_header ak-style1 ak-sticky_header">
      <div class="ak-main_header">
        <div class="container">
          <div class="ak-main_header_in">
            <div class="ak-main-header-left">
              <a class="ak-site_branding" href="/">
                <img src="/assets/img/logo.svg" alt="...">
              </a>
            </div>
            <div class="ak-main-header-center">
              <div class="ak-nav ak-medium">
                <ul class="ak-nav_list">
                  <li>
                    <a href="/">Home</a>
                  </li>
                  <li>
                    <a href="/about">About</a>
                  </li>
                  <li>
                    <a href="/services">Services</a>
                    <ul>
						<?php foreach($services as $service){ ?>
                      <li>
                        <a href="/services/<?php echo str_replace(' ','_',$service['name']); ?>"><?php echo $service['name']; ?></a>
                      </li>
					  <?php } ?>
                    </ul>
                  </li>
                  
                  <li>
                    <a href="/contact">Contact</a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="ak-main-header-right">
              <a href="/login" class="common-btn">
                <span> Sign In</span>
                <span>
                  <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewbox="0 0 15 15" fill="none">
                    <g clip-path="url(#clip0_201_978435345)">
                      <path d="M1.42236 6.99728H13.089M13.089 6.99728L7.48903 1.39728M13.089 6.99728L7.48903 12.5973" stroke="#030917" stroke-linecap="round" stroke-linejoin="round"></path>
                    </g>
                    <defs>
                      <clippath id="clip0_201_978435345">
                        <rect width="14" height="14" fill="white" transform="translate(0.00927734)"></rect>
                      </clippath>
                    </defs>
                  </svg>
                </span>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="nav-bar-border"></div>
    </header>
    <!-- End Header Section -->